## Example 05

set Warehouses;
set Shops;

param cost{i in Warehouses, j in Shops};
param supply{i in Warehouses};
param demand{j in Shops};
param fixed_charge{i in Warehouses};

var amount{i in Warehouses, j in Shops};
var open{i in Warehouses} binary;

minimize Cost : sum{i in Warehouses, j in Shops}cost[i,j]*amount[i,j]
       +sum{i in Warehouses}fixed_charge[i]*open[i];

subject to Supply{i in Warehouses} : sum{j in Shops}amount[i,j]<=supply[i]*open[i];
subject to Demand{j in Shops} : sum{i in Warehouses}amount[i,j]>=demand[j];
subject to positive{i in Warehouses, j in Shops} : amount[i,j]>=0;
